//Experiment No.13
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at    
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
//This Source file is Written by Dr. T. Subbulaskhmi, Professor, 
//School of Computing Science and Engineering, VIT University Chennai 
//using the NARVAL examples of Scilab for Network Topology Creation  
//The Operating System used for writing the code found in this file is Windows 8
//SCILAB version 5.5.2 and NARVAL toolbox version 3.1//This Program is Written by Dr. T. Subbulaskhmi, Professor, School of Computing Science and Engineering, VIT University Chennai using the NARVAL examples of Scilab for Network Topology Creation  

clear;
clc;

NetworkSize=7;//network size
NeworkSquareArea=1000;//network square area side
LocalityRadius=1000;//locality radius
[ToplogyGraph]=NL_T_LocalityConnex(NetworkSize,NeworkSquareArea,LocalityRadius);//generation of a random topology in respect with the Locality method. 
for SourceNode=1:1:NetworkSize
    disp(SourceNode,"node number :");
    dw = 2;
    WindowSize = SourceNode;
    [go,v,pred]=NL_R_Prim(ToplogyGraph,SourceNode,dw,WindowSize)//application of NL_R_Prim
//    disp(go);
    disp(v);
    disp(pred);
    j = pred;
    for x = j
    disp(x);
    plot(j);
    xlabel("Nodenumber", "fontsize", 2)
    ylabel("Distance");
    end
end
for SourceNode=1:1:NetworkSize
    [ToplogyGraph]=NL_T_LocalityConnex(NetworkSize,NeworkSquareArea,LocalityRadius);//generation of a random topology in respect with the Locality method. 
    dw = 2;
    WindowSize = SourceNode;
    [go,v,pred]=NL_R_Prim(ToplogyGraph,SourceNode,dw,WindowSize)//application of NL_R_Prim
//    [dist,pred]=NL_R_Dijkstra(g,i);//application of NL_R_Dijkstra
    go.node_diam(SourceNode)=40;//node diameter
    go.node_border(SourceNode)=10;//node border
    go.node_color(SourceNode)=5;//node color
    [GraphVisualize]=NL_G_ShowGraphN(go,SourceNode);//graph visualization 
xtitle("LocalityConnexMethod","NodeNumber","Distance")
end
5
